using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ConsoleApplication1
{
    class Program
    {
        static int partition (double [] arr1, double []arr2, int low, int high)
        {
            double pivot = arr1[high];
            int i = (low - 1);
            for (int j = low; j <= high - 1; j++)
            {
                if (arr1[j] < pivot)
                {
                    i++;
                    double t = arr1[i];
                    arr1[i] = arr1[j];
                    arr1[j] = t;
                    t = arr2[i];
                    arr2[i] = arr2[j];
                    arr2[j] = t;
                }
            }
            double tt = arr1[i + 1];
            arr1[i + 1] = arr1[high];
            arr1[high] = tt; 
            tt = arr2[i + 1];
            arr2[i + 1] = arr2[high];
            arr2[high] = tt;
            return (i + 1);
        }
        static void quickSort(ref double[] arr1, ref double[] arr2, int low, int high)
        {
            if (low < high)
            {
                int pi = partition(arr1, arr2, low, high);
                quickSort(ref arr1, ref arr2, low, pi - 1);
                quickSort(ref arr1, ref arr2, pi + 1, high);
            }
        }
        static double[] psum(double []a, int n)
        {
            double[] psa = new double[n];
            psa[0] = a[0];
            for(int i = 1; i < n; i++)
            {
                psa[i] = psa[i - 1] + a[i];
            }
            return psa;
        }
        static double funkcija(double[] psa, double[] p, int n)
        {
            double max = 0;
            for(int i = 0; i < n; i++)
            {
                if(i == 0)
                {
                    max = psa[n - 1] * p[i] / 100;
                }
                else
                {
                    double temp = (psa[n - 1] - psa[i - 1]) * p[i] / 100;
                    if(temp > max)
                    {
                        max = temp;
                    }
                }

            }
            return max;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            double[] a = new double[n];
            double[] p = new double[n];
            double[] psa = new double[n];
            for (int i = 0; i < n; i++)
            {
                string str = Console.ReadLine();
                string[] arr = str.Split();
                a[i] = Convert.ToDouble(arr[0]);
                p[i] = Convert.ToDouble(arr[1]);
            }
            quickSort(ref p, ref a, 0, n - 1);
            psa = psum(a, n);
            Console.WriteLine(funkcija(psa, p, n));
            Console.ReadLine();
        }
    }
}